CREATE OR REPLACE FUNCTION UpdateColumn()
RETURNS VOID AS
$BODY$
BEGIN
    IF (EXISTS (SELECT 1 FROM information_schema.columns     
                    WHERE table_name= 'pdv_vd_nfce' 
                         and column_name='dt_envio')
         and EXISTS (SELECT 1 FROM information_schema.columns     
                    WHERE table_name= 'pdv_vd_nfce' 
                         and column_name='qtd_envio'))
    THEN
						 
		UPDATE pdv_vd_nfce
		SET    dt_envio = COALESCE(pdv_vd_nfce.dt_envio, pdv_vd.dt_vd),
		       qtd_envio = COALESCE(pdv_vd_nfce.qtd_envio, 1)
		FROM   pdv_vd
		WHERE  pdv_vd_nfce.cd_vd = pdv_vd.cd_vd
		       AND pdv_vd_nfce.cd_emp = pdv_vd.cd_emp
		       AND pdv_vd_nfce.cd_filial = pdv_vd.cd_filial
		       AND ( pdv_vd_nfce.dt_envio IS NULL
		              OR pdv_vd_nfce.qtd_envio IS NULL );				 
                         
        RAISE NOTICE 'Update inicial realizado com sucesso nas colunas "dt_envio" e "qtd_envio" da tabela "pdv_vd_nfce"' ;
        
    END if;
    
    				 
END;
-- fim bloco principal
$BODY$
LANGUAGE plpgsql VOLATILE
  COST 100;
ALTER FUNCTION UpdateColumn()  OWNER TO postgres;
SELECT UpdateColumn();
DROP FUNCTION UpdateColumn();

